IF  EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_DESC_FUNCIONARIO_CARGO]') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

/****** Object:  UserDefinedFunction [dbo].[UFD_DESCRICAO_DESC]    Script Date: 14/08/2013 16:42:21 ******/
DROP FUNCTION [dbo].[UFD_EST_PROD_DESC_FUNCIONARIO_CARGO]
GO

CREATE FUNCTION UFD_EST_PROD_DESC_FUNCIONARIO_CARGO(@CD_EMP INT, @CD_FILIAL INT, @CD_PROD INT, @CD_FUN INT)
RETURNS @RETURN_REC 
TABLE(
	CD_PROD 			INT,
	CD_FUNC 			INT,
	CD_TBL_DESC     	INT,
	TP_NIVEL			INT, 
	PERC_DESC			MONEY
)
AS 
BEGIN

	-- SELECT * FROM UFD_EST_PROD_DESC_FUNCIONARIO_CARGO(1, 1, 1, 1)

	

	DECLARE @RS_TMP_DESC TABLE(
		CD_PROD 			INT,
		CD_FUNC 			INT,
		CD_TBL_DESC_CARGO	INT,
		TP_NIVEL			INT, 
		PERC_DESC			MONEY,
		DT_INI              DATETIME
	)

	-------------------------------------------------------------------------------------------------------------------------------    
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------    
	DECLARE @RS_TAB_ATIVA TABLE ( CD_EMP INT,    
								  CD_TBL_DESC INT)    

	-------------------------------------------------------------------------------------------------------------------------------    
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------    
	DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,    
										CD_PROD     INT,    
										CD_ARV_MERC_CATEG  INT,    
										CD_ARV_MERC_LINHA  INT,    
										CD_MC     INT,    
										CD_ARV_MERC_FAMILIA  INT,            
										CD_FABRIC    INT)    


	-------------------------------------------------------------------------------------------------------------------------------    
	--BUSCANDO ARVORE MERC. DO PRODUTO    
	-------------------------------------------------------------------------------------------------------------------------------     
	INSERT INTO @EST_PROD_ARV_MERC    			
		SELECT     
			ARV.CD_EMP     ,    
			ARV.CD_PROD     ,    
			ARV.CD_ARV_MERC_CATEG  ,    
			ARV.CD_ARV_MERC_LINHA  ,    
			ARV.CD_MC     ,    
			ARV.CD_ARV_MERC_FAMILIA  ,            
			P.CD_FABRIC     
		FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV 
				INNER JOIN EST_PROD P ON    
					ARV.CD_EMP  = P.CD_EMP    
					AND ARV.CD_PROD = P.CD_PROD    
		WHERE   P.CD_EMP = @CD_EMP     
				AND P.CD_PROD = @CD_PROD 


	-------------------------------------------------------------------------------------------------------------------------------    
	--EXISTE ARVORE MERCADOLOGICA    
	-------------------------------------------------------------------------------------------------------------------------------     
	IF EXISTS(SELECT 1 FROM @EST_PROD_ARV_MERC)
	BEGIN

		INSERT INTO @RS_TAB_ATIVA    
			SELECT  PERC.CD_EMP,    
					PERC.CD_TBL_DESC_CARGO
			FROM FP_CARGO_EST_PROD_TBL_DESC_CARGO PERC inner join 
				 EST_PROD_TBL_DESC_CARGO A ON
					PERC.CD_EMP = A.CD_EMP AND
					PERC.CD_TBL_DESC_CARGO = A.CD_TBL_DESC_CARGO INNER JOIN 
			     EST_PROD_TBL_DESC_CARGO_PRC_FILIAL FIL ON    
					PERC.CD_EMP = FIL.CD_EMP AND    
					PERC.CD_TBL_DESC_CARGO = FIL.CD_TBL_DESC_CARGO inner join 
				 FP_FUNC FUN ON
					PERC.CD_EMP = FUN.CD_EMP AND
					PERC.CD_CARGO = FUN.CD_CARGO
			WHERE	@CD_EMP    = PERC.CD_EMP AND        
					@CD_FILIAL = FIL.CD_FILIAL AND
					1          = A.STS_TBL AND    
					FUN.CD_FUN = @CD_FUN


		-------------------------------------------------------------------------------------------------------------------------------    
		--EXISTE TABELA ATIVA  
		-------------------------------------------------------------------------------------------------------------------------------     

		IF EXISTS(SELECT 1 FROM @RS_TAB_ATIVA)
		BEGIN
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO @RS_TMP_DESC     
				SELECT    
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						1 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI      
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_PROD B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO    
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC     
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND    
							B.CD_PROD = ARV.CD_PROD  
			
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
			-------------------------------------------------------------------------------------------------------------------------------    				
			INSERT INTO @RS_TMP_DESC     
				SELECT    
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						2 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI     
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_FAMILIA B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO    
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC     
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND    
							B.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA 
			
			-------------------------------------------------------------------------------------------------------------------------------        
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
			-------------------------------------------------------------------------------------------------------------------------------    				
			INSERT INTO @RS_TMP_DESC     
				SELECT    
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						3 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI      
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_MC B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO    
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC     
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND    
							B.CD_MC = ARV.CD_MC        

			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO @RS_TMP_DESC     
				SELECT   
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						4 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI       
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_PROD_FABRIC B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO 
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC 
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND    
							B.CD_FABRIC = ARV.CD_FABRIC

			------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS     
			-------------------------------------------------------------------------------------------------------------------------------    
				
				INSERT INTO @RS_TMP_DESC     
				SELECT   
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						5 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI    
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_CATEGORIA B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO 
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC   
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND    
							B.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG  
			
			
			
							
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 -  LINHAS  
			-------------------------------------------------------------------------------------------------------------------------------    
		 
		 INSERT INTO @RS_TMP_DESC     
				SELECT   
						@CD_PROD,    
						@CD_FUN,    
						A.CD_TBL_DESC_CARGO,    
						6 AS TP_NIVEL,
						B.PERC_DESC,
					    A.DT_INI  
				FROM EST_PROD_TBL_DESC_CARGO A    
						INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_ARV_MERC_LINHA B ON    
							A.CD_EMP = B.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = B.CD_TBL_DESC_CARGO    
						INNER JOIN @RS_TAB_ATIVA TBA ON    
							A.CD_EMP = TBA.CD_EMP AND    
							A.CD_TBL_DESC_CARGO = TBA.CD_TBL_DESC 
						INNER JOIN @EST_PROD_ARV_MERC ARV ON    
							B.CD_EMP = ARV.CD_EMP AND       
							B.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA
							
			 
						   
						
		END
	END

	INSERT INTO @RETURN_REC
	SELECT TOP 1 CD_PROD, CD_FUNC, CD_TBL_DESC_CARGO, TP_NIVEL, PERC_DESC 
		  FROM @RS_TMP_DESC 
		 ORDER BY DT_INI DESC, TP_NIVEL ASC, PERC_DESC DESC

	RETURN
END